<?php
/**
 * The template for displaying all single posts
 */
get_header();
$banner_image = get_field('banner_image'); ?>
<div class="progressBar">
    <div class="proGress" id="progressId"></div>
</div>

<section class="mind-details-sec1">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php the_title(); ?></h1>
                <h6><?php echo get_the_date('F j, Y'); ?> <span>•</span> <?php echo reading_time(); ?> min read</h6>
                <?php the_excerpt(); ?>
                <?php if(!empty($banner_image)){ ?><img src="<?php echo $banner_image['url']; ?>" alt="<?php echo $banner_image['alt']; ?>" class="full-img"><?php } ?>
                <?php the_content(); ?>
            </div>
        </div>
    </div>
</section>


<!-- COMMENT FORM – DYNAMIC & BEAUTIFUL -->
<!-- CLEAN & BEAUTIFUL COMMENT FORM -->
<!-- <section class="comment-form-section">
    <div class="container">
        <?php //comment_form(); ?>
    </div>
</section> -->

<section class="home-sec6 pb-96 md">
    <div class="slider-row">
        <div class="container">
            <h3 class="text-center">Similar Post</h3>
            <div class="row slid-four">
          
                
                <?php
                // Get current post ID & its categories
                $current_id = get_the_ID();
                $cats       = wp_get_post_categories($current_id, ['fields' => 'ids']);

                // Query: 4 random posts from same categories, exclude current
                $related = new WP_Query(array(
                    'posts_per_page'      => 4,
                    'post__not_in'        => array($current_id),
                    'category__in'        => $cats,
                    'orderby'             => 'rand',
                    'ignore_sticky_posts' => true,
                ));

                if ($related->have_posts()) :
                    while ($related->have_posts()) : $related->the_post();
                        $thumb = has_post_thumbnail() ? get_the_post_thumbnail_url(null, 'blog') : get_template_directory_uri() . '/images/sild-img5.png';
                        $cat   = get_the_category();
                        $cat_name = esc_html($cat[0]->name);
                ?>
                    <div class="item col-md-3">
                        <a href="<?php the_permalink(); ?>">
                        <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="top-img">
                    </a>
                        <span><?php echo $cat_name; ?></span>
                        <h5><?php echo wp_trim_words(get_the_title(), 8, '...'); ?></h5>
                        <a href="<?php the_permalink(); ?>" class="rd">Read More</a>
                    </div>
                <?php endwhile;
                    wp_reset_postdata();
                else :
                    echo '<p class="col-12">No similar posts found.</p>';
                endif; ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer();



