<?php
/* Template Name: Home*/
get_header(); ?>
<?php $banner_title = get_field('banner_title');
$banner_text = get_field('banner_text'); ?>
<section class="home-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-10">
                <?php if(!empty($banner_title)){ ?><h1><?php echo $banner_title; ?></h1><?php }else{ the_title('<h1>', '</h1>'); } ?>
                <?php if(!empty($banner_text)){ echo wpautop($banner_text); } ?>
            </div>
        </div>
    </div>
</section>

<section class="home-sec2">
    <div class="owl-carousel owl-theme home-sec2-slid">

        <?php
        // Get posts from ACF relationship field
        $featured_posts = get_field('featured_today'); // ACF field name

        if ($featured_posts) :
        foreach ($featured_posts as $post) :
        setup_postdata($post);

        // Get first category
        $cats = get_the_category();
        $cat_name = esc_html($cats[0]->name);

        // Featured image or fallback
        $thumb = get_the_post_thumbnail_url($post, 'feature_today'); ?>
        <div class="item">
            <div class="content-wraper">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <h6>Featured Today</h6>
                            <h2><?php the_title(); ?></h2>
                            <p><?php echo wp_trim_words(get_the_content(), 60, '...'); ?></p>
                            <ul>
                                <li><?php echo $cat_name; ?></li>
                                <li><?php echo reading_time(); ?> min read</li>
                            </ul>
                            <a href="<?php the_permalink(); ?>" class="main-btn">Read Full Article</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="right-img-wraper">
                <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>">
            </div>
        </div>
        <?php endforeach;
        wp_reset_postdata();
        endif; ?>

    </div>
</section>


<?php $latest_content = get_field('latest_content'); ?>
<section class="home-sec3">
    <div class="container">
        <div class="row">
            <div class="col-lg-9">
                <?php if(!empty($latest_content)){ echo wpautop($latest_content); } ?>
            </div>
            <div class="col-lg-8">
                <div id="blogsearchresult" style="display:none"></div>
                <div id="oldblogarticles">
                <?php
                // Get posts from ACF relationship field
                $latest_posts = get_field('latest_essays');

                if ($latest_posts) :
                    foreach ($latest_posts as $post) :
                        setup_postdata($post);

                        // Category
                        $cats = get_the_category();
                        $cat_name = esc_html($cats[0]->name);

                        // Featured image
                        $thumb = get_the_post_thumbnail_url($post, 'latest');
                ?>
                <div class="box-wraper">
                    <div class="img-wraper">
                        <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="main-img">
                        <?php echo do_shortcode('[Sassy_Social_Share]') ?>
                    </div>
                    <div class="text-wraper">
                        <div class="flex-item">
                            <h5><?php echo $cat_name; ?></h5>
                            <h6><?php echo reading_time(); ?> min read</h6>
                        </div>
                        <h3><?php the_title(); ?></h3>
                        <p><?php echo wp_trim_words(get_the_content(), 30, '...'); ?></p>
                        <a href="<?php the_permalink(); ?>" class="main-btn">Read More</a>
                    </div>
                </div>
                <?php
                endforeach;
                wp_reset_postdata(); 
                endif; ?>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="sticky-box">
                    <div class="form-wraper">
                        <form action="">
                            <input type="search" name="s" id="live-search" placeholder="Search">
                        </form>
                    </div>
                    <h5>CATEGORIES</h5>
                    <ul>
                        <?php
                        // Get ALL categories
                        $categories = get_categories(array(
                            'orderby'    => 'name',
                            'order'      => 'ASC',
                            'hide_empty' => true, // Hide empty categories
                        ));

                        // Add "ALL" first
                        $total_posts = wp_count_posts()->publish;
                        ?>
                        <li>
                            <strong><a href="javascript:void(0)">ALL</a></strong>
                            <span>(<?php echo $total_posts; ?>)</span>
                        </li>

                        <?php foreach ($categories as $cat) : ?>
                            <li>
                                <strong>
                                    <a href="<?php echo get_category_link($cat->term_id); ?>">
                                        <?php echo esc_html($cat->name); ?>
                                    </a>
                                </strong>
                                <span>(<?php echo $cat->count; ?>)</span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <h5>RECENT POSTS</h5>
                    <?php
                        $recent = new WP_Query(array(
                            'posts_per_page' => 3,
                            'post_status'    => 'publish',
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                        ));

                        if ($recent->have_posts()) :
                            while ($recent->have_posts()) : $recent->the_post(); ?>
                                <div class="textwraper">
                                    <p><?php the_title(); ?></p>
                                    <h6>
                                        <?php echo get_the_date('F j, Y'); ?> • 
                                        <?php echo reading_time(); ?> min read
                                    </h6>
                                    <a href="<?php the_permalink(); ?>">Read More</a>
                                </div>
                        <?php
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="home-sec4">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2>All post</h2>
            </div>
            <div class="col-lg-8">
                <?php
                $latest = new WP_Query(array(
                    'posts_per_page' => 6,
                    'post_status'    => 'publish',
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                ));
                if ($latest->have_posts()) :
                    while ($latest->have_posts()) : $latest->the_post();
                        $cats    = get_the_category();
                        $cat     = !empty($cats) ? esc_html($cats[0]->name) : 'Life'; ?>
                        <div class="review-card">
                            <span><?php echo $cat; ?></span>
                            <h5><?php the_title(); ?></h5>
                            <h6>
                                <?php echo get_the_date('F j, Y'); ?>
                                <span>•</span> <?php echo reading_time(); ?> min read
                            </h6>
                            <p><?php echo wp_trim_words(get_the_content(), 20, '…'); ?></p>
                            <a href="<?php the_permalink(); ?>" class="rm">Read More</a>

                            <div class="flex-box">
                                <div class="social-like">
                                <?php echo do_shortcode('[Sassy_Social_Share]') ?>
                                <?php echo do_shortcode('[wp_ulike]') ?>
                                </div>

                                <!-- <h4>
                                    <a href="javascript:void(0)">
                                        <img src="<?php //echo get_template_directory_uri(); ?>/assets/images/i6.svg" alt="">
                                        <?php //comments_number('0 Comments', '1 Comment', '% Comments'); ?>
                                    </a>
                                </h4> -->
                            </div>
                        </div>
                <?php
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>

            </div>
            <div class="col-lg-4">
                <div class="recent-post-box">
                    <h4>Recent Post</h4>
                    <?php
                        $recent = new WP_Query(array(
                            'posts_per_page' => 4,
                            'post_status'    => 'publish',
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                        ));

                        if ($recent->have_posts()) :
                            while ($recent->have_posts()) : $recent->the_post(); ?>
                            <div class="text-box">
                                <p><?php the_title(); ?></p>
                                <h6>
                                    <?php echo get_the_date('F j, Y'); ?> • 
                                    <?php echo reading_time(); ?> min read
                                </h6>
                                <a href="<?php the_permalink(); ?>">Read More</a>
                            </div>
                        <?php
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="home-sec5">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <?php the_content(); ?>
                <?php 
                $about_page = get_field('about_page'); // ACF Link field
                if ($about_page) : 
                    $url    = $about_page['url'];
                    $title  = $about_page['title'] ?: 'Read More';
                    $target = $about_page['target'] ? 'target="_blank"' : '';
                ?>
                <a href="<?php echo esc_url($url); ?>" class="main-btn" <?php echo $target; ?>><?php echo esc_html($title); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="home-sec6">
    <div class="slider-row">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h3>Series</h3>
                    <div class="owl-carousel owl-theme slid-four">
                    <?php
                    $series_terms = get_terms(array(
                        'taxonomy'   => 'series',
                        'hide_empty' => true,
                        'orderby'    => 'name',
                        'order'      => 'ASC',
                    ));

                    if (!empty($series_terms) && !is_wp_error($series_terms)) :
                        foreach ($series_terms as $term) :

                            // GET ACF IMAGE FROM TAXONOMY
                            $image = get_field('image', 'series_' . $term->term_id);
                            $thumb = is_array($image) ? $image['url'] : '';
                            if (!$thumb) {
                                $thumb = get_template_directory_uri() . '/assets/images/sild-img1.png';
                            }

                            // GET FIRST POST TITLE
                            $first_post = get_posts(array(
                                'post_type'      => 'post',
                                'posts_per_page' => 1,
                                'tax_query'      => array(array(
                                    'taxonomy' => 'series',
                                    'field'    => 'term_id',
                                    'terms'    => $term->term_id,
                                )),
                            ));
                            $title = $first_post ? $first_post[0]->post_title : 'Explore Series';
                    ?>
                            <div class="item">
                                <a href="<?php echo get_term_link($term); ?>">
                                    <img src="<?php echo esc_url($thumb); ?>" 
                                         alt="<?php echo esc_attr($term->name); ?>" 
                                         class="top-img">
                                </a>
                                <span><?php echo esc_html($term->name); ?></span>
                                <h5><?php echo esc_html($title); ?></h5>
                                <a href="<?php echo get_term_link($term); ?>" class="rd">Read More</a>
                            </div>
                    <?php
                        endforeach;
                    else :
                        echo '<p>No series found.</p>';
                    endif;
                    ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $featured_essays_title = get_field('featured_essays_title'); ?>
    <div class="slider-row">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <?php if(!empty($featured_essays_title)){ ?><h3><?php echo $featured_essays_title; ?></h3><?php } ?>
                    <div class="owl-carousel owl-theme slid-four">
                        <?php
                            $featured = get_field('featured_essays'); // ← YOUR ACF FIELD
                            if ($featured) :
                                foreach ($featured as $post) :
                                    setup_postdata($post);
                                    $cat = get_the_category();
                                    $cat_name = esc_html($cat[0]->name);
                                    $thumb = get_the_post_thumbnail_url($post, 'blog');
                            ?>
                                    <div class="item">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="top-img">
                                        </a>
                                        <span><?php echo $cat_name; ?></span>
                                        <h5><?php the_title(); ?></h5>
                                        <a href="<?php the_permalink(); ?>" class="rd">Read More</a>
                                    </div>
                            <?php
                                endforeach;
                                wp_reset_postdata();
                            endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $stay_connect_content = get_field('stay_connect_content', 'option');
$connect_short_text = get_field('connect_short_text', 'option'); ?>
<section class="home-sec7">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="wraper-box">
                    <?php if(!empty($stay_connect_content)){ echo wpautop($stay_connect_content); } ?>
                    <div class="form-wraper">
                        <?php echo do_shortcode('[contact-form-7 id="c24e930" title="Stay Connected"]'); ?>
                    </div>
                    <?php if(!empty($connect_short_text)){ echo wpautop($connect_short_text); } ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer();