<?php

/* Template Name: About*/
get_header(); ?>

<?php $banner_title = get_field('banner_title');
$banner_content = get_field('banner_content');
$images = get_field('images'); ?>
<section class="inner-banner about-inner">
    <div class="container">
        <div class="row">
            <div class="col-lg-10">
                <?php if(!empty($banner_title)){ ?><h1><?php echo $banner_title; ?></h1><?php } ?>
                <?php if(!empty($banner_content)){ echo wpautop($banner_content); } ?>
            </div>
        </div>
    </div>
</section>

<section class="about-sec1">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 col-md-6">
                <?php if( $images ): ?>
                <div class="owl-carousel owl-theme about-slid">
                    <?php foreach( $images as $image ): ?>
                    <div class="item"><img src="<?php echo esc_url($image['sizes']['about']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /></div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="text-box">
            <?php the_content(); ?>
        </div>
    </div>
</section>

<?php if( have_rows('why') ): ?>
<section class="about-sec2">
    <div class="container">
        <?php $c = 1; while( have_rows('why') ) : the_row();
        $title = get_sub_field('title'); 
        $content = get_sub_field('content');
        $image = get_sub_field('image');
        if($c%2 == 0){
            $cls1 = 'ps-5';
        }else{
            $cls1 = 'pe-5';
        } ?>
        <div class="row">
            <div class="col-lg-6 col-md-6 <?php echo $cls1; ?>">
                <?php if(!empty($title)){ ?><h2><?php echo $title; ?></h2><?php } ?>
                <?php if(!empty($content)){ echo wpautop($content); } ?>
            </div>
            <div class="col-lg-6 col-md-6">
                <?php if(!empty($image)){ ?><img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" class="side-img"><?php } ?>
            </div>
        </div>
        <?php $c++; endwhile; ?>
    </div>
</section>
<?php endif; ?>

<section class="about-sec3">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2>Instagram</h2>
                <div class="owl-carousel owl-theme images-slider">
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img9.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img10.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img11.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img12.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img13.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img14.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/slid-img11.png" alt="" class="main-img">
                        <a href="#?" class="hover-show"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt=""></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $stay_connect_content = get_field('stay_connect_content', 'option');
$connect_short_text = get_field('connect_short_text', 'option'); ?>
<section class="home-sec7">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="wraper-box">
                    <?php if(!empty($stay_connect_content)){ echo wpautop($stay_connect_content); } ?>
                    <div class="form-wraper">
                        <?php echo do_shortcode('[contact-form-7 id="c24e930" title="Stay Connected"]'); ?>
                    </div>
                    <?php if(!empty($connect_short_text)){ echo wpautop($connect_short_text); } ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php get_footer();