<footer>
    <?php $copyright = get_field('copyright', 'option');
    $facebook = get_field('facebook', 'option');
    $twitter = get_field('twitter', 'option');
    $instagram = get_field('instagram', 'option');
    $bluesky = get_field('bluesky', 'option'); ?>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="flex-wraper">

                    <?php wp_nav_menu( array( 'theme_location' => 'header', 'items_wrap'    => '<ul class="menu">%3$s</ul>', 'container' => false ) ); ?>
                    <ul class="social-icon">
                        <?php if( $facebook ): ?><li><a href="<?php echo $facebook; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook-icon.svg" alt=""></a></li><?php endif; ?>
                        <?php if( $instagram ): ?><li><a href="<?php echo $instagram; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram-icon.svg" alt=""></a></li><?php endif; ?>
                        <?php if( $bluesky ): ?><li><a href="<?php echo $bluesky; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/butterfly-icon.svg" alt=""></a></li><?php endif; ?>
                        <?php if( $twitter ): ?><li><a href="<?php echo $twitter; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/x-icon.svg" alt=""></a></li><?php endif; ?>
                    </ul>
                </div>
                <?php if(!empty($copyright)){ ?><h6>Copyright © <?php echo date('Y'); ?> <?php echo $copyright; ?></h6><?php } ?>
            </div>
        </div>
    </div>
</footer>
<script>
// Inline AJAX Search - No external file needed
jQuery(document).ready(function($) {
    var searchInput = $('#live-search');
    var resultBox   = $('#blogsearchresult');
    var oldBox      = $('#oldblogarticles');
    var timer;

    searchInput.on('input', function() {
        clearTimeout(timer);
        var query = $(this).val().trim();

        // Show original if empty
        if (query === '') {
            resultBox.hide().empty();
            oldBox.show();
            return;
        }

        // Debounce: wait 400ms
        timer = setTimeout(function() {
            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'custom_blog_search',
                    s: query,
                    nonce: '<?php echo wp_create_nonce('blog_search_nonce'); ?>'
                },
                beforeSend: function() {
                    resultBox.html('<p class="search-loading">Searching...</p>').show();
                    oldBox.hide();
                },
                success: function(response) {
                    if (response.success && response.data) {
                        resultBox.html(response.data);
                    } else {
                        resultBox.html('<p class="no-results">No essays found for "<strong>' + query + '</strong>"</p>');
                    }
                },
                error: function() {
                    resultBox.html('<p class="error">Search failed. Please try again.</p>');
                }
            });
        }, 400);
    });

    // Optional: Clear on ESC
    $(document).on('keyup', function(e) {
        if (e.key === 'Escape') {
            searchInput.val('');
            resultBox.hide().empty();
            oldBox.show();
        }
    });
});
</script>

<?php wp_footer(); ?>
</body>
</html>

