<?php get_header();
// Get current category ID
$category = get_queried_object();
$cat_id   = $category->term_id;
$content = get_field('content', 'category_' . $cat_id);
$other_title = get_field('other_title', 'category_' . $cat_id); ?>
<?php if(is_category(3)){
    $cls = 'life-inner';
    $cls2 = 'life-sec1';
}elseif(is_category(4)){
    $cls = 'then-some-blush';
    $cls2 = 'them-some-sec1';
}else{
    $cls = 'mind-inner';
    $cls2 = '';
}  ?>
<section class="inner-banner <?php echo $cls; ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-10">
                <h1><?php echo single_cat_title( '', false ); ?></h1>
                <?php echo category_description(); ?>
            </div>
        </div>
    </div>
</section>

<?php if(!empty($content)){ ?>
<section class="mind-sec1">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php echo wpautop($content); ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<section class="mind-sec2 <?php echo $cls2; ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php if ( have_posts() ) :  ?>
                <?php while ( have_posts() ) : the_post(); ?>
                <div class="text-wraper">
                    <h3><?php the_title(); ?></h3>
                    <h5><?php echo get_the_date('F j, Y'); ?> <span>•</span> <?php echo reading_time(); ?> min read</h5>
                    <p><?php
                    if ( has_excerpt() ) {
                        echo wp_trim_words( get_the_excerpt(), 40, '...' );
                    } else {
                        echo wp_trim_words( get_the_content(), 40, '...' );
                    }
                    ?></p>
                    <a href="<?php the_permalink(); ?>" class="rm">Read More</a>
                    <div class="flex-box">
                        <div class="social-like">
                        <?php echo do_shortcode('[Sassy_Social_Share]') ?>
                        <?php echo do_shortcode('[wp_ulike]') ?>
                        </div>
                        <!-- <h4>
                            <a href="javascript:void(0)">
                                <img src="<?php //echo get_template_directory_uri(); ?>/assets/images/i6.svg" alt="">
                                <?php //comments_number('0 Comments', '1 Comment', '% Comments'); ?>
                            </a>
                        </h4> -->
         
                    </div>
                </div>
                <?php endwhile;

                // Optional: Pagination
                the_posts_pagination( array(
                    'mid_size'  => 2,
                    'prev_text' => __( 'Previous', 'textdomain' ),
                    'next_text' => __( 'Next', 'textdomain' ),
                ) );

                else : ?>
                    <p>No posts found in this category.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="home-sec6 pb-96">
    <div class="slider-row">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <?php if(!empty($other_title)){ ?><h3><?php echo $other_title; ?></h3><?php } ?>
                    <div class="owl-carousel owl-theme slid-four">
                        <?php
                        // Get current category ID (if on category page)
                        $current_cat = is_category() ? get_queried_object_id() : 0;

                        // Query: 5 latest posts NOT in current category
                        $args = array(
                            'posts_per_page' => -1,
                            'post_type'      => 'post',
                            'post_status'    => 'publish',
                            'category__not_in' => $current_cat ? array($current_cat) : array(),
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                        );

                        $other_posts = new WP_Query($args);

                        if ($other_posts->have_posts()) :
                            while ($other_posts->have_posts()) : $other_posts->the_post();
                                $categories = get_the_category();
                                $cat_name   = esc_html($categories[0]->name);
                                $thumb      = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'blog') : get_template_directory_uri() . '/assets/images/sild-img5.png';
                        ?>
                        <div class="item">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="top-img">
                                    </a>
                                    <span><?php echo $cat_name; ?></span>
                                    <h5><?php echo wp_trim_words(get_the_title(), 10, '...'); ?></h5>
                                    <a href="<?php the_permalink(); ?>" class="rd">Read More</a>
                                </div>
                        <?php
                            endwhile;
                            wp_reset_postdata();
                        else :
                            echo '<p>No posts found.</p>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer();