<?php
   /* The template for displaying archive pages  */
   get_header(); ?>

<section class="hm_banner innerbanner">
    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/inner_banner_blog_dt.png" alt="">
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 m-auto text-center">
                    <h1><?php the_archive_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="blog">
    <div class="container">
        <div class="row">
         <div class="col-lg-8 col-md-7">
            <div class="row">
            <?php while ( have_posts() ) : the_post(); ?>
               <div class="col-lg-6 col-md-12">
                  <div class="blogItem">
                      <div class="blog_img">
                          <?php the_post_thumbnail(); ?>
                      </div>
                      <div class="blog_txt">
                          <?php $post_date = get_the_date( 'M j, Y' ); ?>
                          <h5><?php echo $post_date; ?></h5>
                          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                           <?php $content = get_the_content();
                              $trimmed_content = wp_trim_words( $content, 14, '....' ); ?>
                          <p><?php echo $trimmed_content; ?></p>
                          <a href="<?php the_permalink(); ?>">Read More <span><img src="<?php echo get_template_directory_uri(); ?>/assets/images/arrow-blue-right.svg" alt="img"></span></a>
                      </div>
                  </div>
              </div>
            <?php endwhile; ?>
            </div>
         </div>
         <div class="col-lg-4 col-md-5">
                <div class="search_info">
                    <form action="<?php echo home_url(); ?>" id="search-form" method="get">
                        <input type="text" name="s" id="s" placeholder="Search" value="" onblur="if(this.value=='')this.value='Search'" onfocus="if(this.value=='type your search')this.value=''" />
                        <input type="submit" value="" />
                    </form>
                </div>
                <div class="subscribe_info">
                    <h3>Subscribe by Email</h3>
                    <?php echo do_shortcode('[contact-form-7 id="92ccffe" title="Blog Subscribe"]'); ?>
                </div>
                <div class="catergories_info">
                    <h3>Categories</h3>
                    <ul>
                        <?php  $categories = get_categories();
                        foreach($categories as $category){
                          echo '<li><a href="' .get_category_link($category->term_id) . '">' . $category->name . '</a></li>';
                        } ?>
                    </ul>
                </div>
            </div>
      </div>
   </div>
</section>

<?php get_footer(); ?>