<?php /* Template Name: Portfolio */
get_header();
?>

<!-- ! Main ! -->

<section class="hm_banner innerBanner" id="home">
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="innerTxt">
                        <h1><?php the_title(); ?></h1>
                        <ul class="breadCrumb">
                            <li><a href="<?php get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="stroke_dots one"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke1.png" alt="stroke-line"></div>
    <div class="stroke_dots two"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke2.png" alt="stroke-line"></div>
    <div class="stroke_dots three"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke3.png" alt="stroke-line"></div>
    <div class="stroke_dots four"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke4.png" alt="stroke-line"></div>
</section>
<?php if( have_rows('case_study_list') ): ?>
<section class="pfSec1 defaultPadding">
    <div class="container">
        <div class="heading_txt">
            <?php if(get_field('case_study_heading')){ ?>
                <h2><?php echo get_field('case_study_heading'); ?></h2>
            <?php } ?>
            <div class="gpArrow">
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
        <!-- Swiper -->
        <div class="swiper portfolioSwiper">
            <div class="swiper-wrapper">
                <?php while( have_rows('case_study_list') ) : the_row();
            $cs_icon = get_sub_field('case_study_list_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $cs_icon ) {
                    $img_url = esc_url( $cs_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($cs_icon['alt']) ? esc_attr($cs_icon['alt']) : esc_attr($cs_icon['title']);
                } ?>
                <div class="swiper-slide">
                    <div class="eachCaseSty">
                        <div class="row align-items-lg-center align-items-start flex-md-row-reverse">
                            <div class="col-md-6">
                                <div class="imgRound">
                                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="cs_details">
                                    <?php if(get_sub_field('case_study_list_heading')){ ?>
                                    <h3><?php echo get_sub_field('case_study_list_heading'); ?></h3>
                                    <?php } ?>
                                    <?php if(get_sub_field('case_study_strong_content_1')){ ?>
                                    <p><strong><?php echo get_sub_field('case_study_strong_text_1'); ?>:</strong> <?php echo get_sub_field('case_study_strong_content_1'); ?></p>
                                    <?php } ?>
                                    <?php if(get_sub_field('case_study_strong_content_2')){ ?>
                                    <p><strong><?php echo get_sub_field('case_study_strong_text_2'); ?>:</strong> <?php echo get_sub_field('case_study_strong_content_2'); ?></p>
                                    <?php } ?>
                                    <?php if(get_sub_field('case_study_strong_content_3')){ ?>
                                    <p><strong><?php echo get_sub_field('case_study_strong_text_3'); ?>:</strong> <?php echo get_sub_field('case_study_strong_content_3'); ?></p>
                                    <?php } ?>
                                    <?php $result_title = get_sub_field('case_study_result_title'); ?>
                                    <?php if( have_rows('case_study_result_list') ):
                                    if ( $result_title ) : ?>
                                    <h5><?php echo esc_html( $result_title ); ?>:</h5>
                                    <?php endif; ?>
                                    <ul class="tickCircle">
                                        <?php  
                                            while( have_rows('case_study_result_list') ) : the_row(); ?>
                                        <li><?php echo get_sub_field('case_study_result_text'); ?></li>
                                    <?php endwhile; ?>
                                    </ul>
                                <?php endif; ?>
                                    <p><strong><?php echo get_sub_field('case_study_strong_text_4'); ?>:</strong> <?php echo get_sub_field('case_study_strong_content_4'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<?php if( have_rows('corporate_success_story_list') ): ?>
<section class="pfSec2 defaultPadding">
    <div class="container">
        <?php if(get_field('training_success_main_heading')){ ?>
                <h2><?php echo get_field('training_success_main_heading'); ?></h2>
            <?php } ?>

             <?php $count = 1;
            while( have_rows('corporate_success_story_list') ) : the_row();
                if($count % 2 == 0){ ?>
                <div class="row flex-md-row-reverse align-items-lg-center align-items-start">
            <div class="col-md-6">
                <?php $cts_icon = get_sub_field('corporate_success_list_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $cts_icon ) {
                    $img_url = esc_url( $cts_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($cts_icon['alt']) ? esc_attr($cts_icon['alt']) : esc_attr($cts_icon['title']);
                } ?>
                <div class="imgRound">
                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="cs_details">
                    <?php if(get_sub_field('corporate_success_list_heading')){ ?>
                    <h3><?php echo get_sub_field('corporate_success_list_heading'); ?></h3>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_1')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_1'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_1'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_2')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_2'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_2'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_3')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_3'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_3'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_4')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_4'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_4'); ?></p>
                    <?php } ?>
                    <?php $outcome_title = get_sub_field('corporate_outcomes_title'); ?>
                    <?php $technology_title = get_sub_field('corporate_technology_title'); ?>
                    <?php if( have_rows('corporate_outcomes_list') ):
                    if($outcome_title) : ?>
                    <h5><?php echo $outcome_title; ?>:</h5>
                    <?php endif; ?>
                    <ul class="tickCircle">
                        <?php while( have_rows('corporate_outcomes_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('corporate_outcomes_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if( have_rows('corporate_technologies_list') ): 
                        if($technology_title): ?>
                    <h5><?php echo $technology_title; ?>:</h5>
                    <?php endif; ?>
                    <ul class="tickCircle">
                        <?php while( have_rows('corporate_technologies_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('corporate_technologies_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if(get_sub_field('corporate_success_strong_text_5')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_5'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_5'); ?></p><?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_6')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_6'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_6'); ?></p><?php } ?>
                </div>
            </div>
        </div>
    <?php } else { ?>
        <div class="row align-items-lg-center align-items-start mb60">
            <div class="col-md-6">
                <?php $cts_icon = get_sub_field('corporate_success_list_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $cts_icon ) {
                    $img_url = esc_url( $cts_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($cts_icon['alt']) ? esc_attr($cts_icon['alt']) : esc_attr($cts_icon['title']);
                } ?>
                <div class="imgRound">
                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="cs_details">
                    <?php if(get_sub_field('corporate_success_list_heading')){ ?>
                    <h3><?php echo get_sub_field('corporate_success_list_heading'); ?></h3>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_1')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_1'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_1'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_2')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_2'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_2'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_3')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_3'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_3'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_4')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_4'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_4'); ?></p>
                    <?php } ?>
                    <?php $outcome_title = get_sub_field('corporate_outcomes_title'); ?>
                    <?php $technology_title = get_sub_field('corporate_technology_title'); ?>
                    <?php if( have_rows('corporate_outcomes_list') ):
                    if($outcome_title) : ?>
                    <h5><?php echo $outcome_title; ?>:</h5><?php endif; ?>
                    <ul class="tickCircle">
                        <?php while( have_rows('corporate_outcomes_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('corporate_outcomes_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if( have_rows('corporate_technologies_list') ): 
                        if($technology_title) :?>
                    <h5><?php echo $technology_title; ?>:</h5><?php endif; ?>
                    <ul class="tickCircle">
                        <?php while( have_rows('corporate_technologies_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('corporate_technologies_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if(get_sub_field('corporate_success_strong_text_5')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_5'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_5'); ?></p><?php } ?>
                    <?php if(get_sub_field('corporate_success_strong_text_6')){ ?>
                    <p><strong><?php echo get_sub_field('corporate_success_strong_text_6'); ?>:</strong> <?php echo get_sub_field('corporate_success_content_6'); ?></p><?php } ?>
                </div>
            </div>
        </div>
        <?php } $count++; endwhile; ?>
    </div>
</section>
<?php endif; ?>
<?php if( have_rows('educational_program_list') ): ?>
<section class="pfSec3 defaultPadding">
    <div class="container">
        <?php if(get_field('educational_program_heading')){ ?>
            <h2><?php echo get_field('educational_program_heading'); ?></h2>
        <?php } ?>
        <?php while( have_rows('educational_program_list') ) : the_row();
        $ep_icon = get_sub_field('educational_program_list_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $ep_icon ) {
                    $img_url = esc_url( $ep_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($ep_icon['alt']) ? esc_attr($ep_icon['alt']) : esc_attr($ep_icon['title']);
                } ?>
        <div class="row align-items-md-stretch">
            <div class="col-md-6">
                <div class="imgRound">
                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="cs_details">
                     <?php if(get_sub_field('educational_program_list_heading')){ ?>
                    <h3><?php echo get_sub_field('educational_program_list_heading'); ?></h3>
                    <?php } ?>
                    <?php if(get_sub_field('educational_program_strong_text_1')){ ?>
                    <p><strong><?php echo get_sub_field('educational_program_strong_text_1'); ?>:</strong> <?php echo get_sub_field('educational_program_content_1'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('educational_program_strong_text_2')){ ?>
                    <p><strong><?php echo get_sub_field('educational_program_strong_text_2'); ?>:</strong> <?php echo get_sub_field('educational_program_content_2'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('educational_program_strong_text_3')){ ?>
                    <p><strong><?php echo get_sub_field('educational_program_strong_text_3'); ?>:</strong> <?php echo get_sub_field('educational_program_content_3'); ?></p>
                    <?php } ?>
                    <?php if(get_sub_field('educational_program_strong_text_4')){ ?>
                    <p><strong><?php echo get_sub_field('educational_program_strong_text_4'); ?>:</strong> <?php echo get_sub_field('educational_program_content_4'); ?></p>
                    <?php } ?>
                    <?php $program_conponents = get_sub_field('program_components_title'); ?>
                    <?php $achievements = get_sub_field('achievements_title');?>
                    <?php $unique_quebec = get_sub_field('unique_quebec_title');?>
                    <?php if( have_rows('components_list') ):
                          if($program_conponents) : ?>
                    <h5><?php echo $program_conponents; ?>:</h5><?php endif; ?>
                    <ul class="tickCircle">
                       <?php while( have_rows('components_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('components_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if( have_rows('achievements_list') ):
                    if($achievements) : ?>
                    <h5><?php echo $achievements; ?>:</h5><?php endif; ?>
                    <ul class="tickCircle">
                        <?php while( have_rows('achievements_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('achievements_text'); ?></li>
                        <?php endwhile; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if( have_rows('unique_quebec_list') ): 
                        if($unique_quebec) :?>
                    <h5><?php echo $unique_quebec; ?>:</h5><?php endif; ?>
                    <ul class="tickCircle">
                    <?php while( have_rows('unique_quebec_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('unique_quebec_text'); ?></li>
                    <?php endwhile; ?>
                </ul>
            <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endwhile; ?>
    </div>
</section>
<?php endif; ?>
<!-- ! Main end ! -->

<?php get_footer(); ?>