<?php /* Template Name: Home */
get_header();
?>

<!-- ! Main ! -->

<section class="hm_banner" id="home">
    <div class="middle_caption">
        <div class="container">
            <div class="row flex-md-row-reverse align-items-md-center">
                <div class="col-md-6">
                    <div class="group_img">
                    	<?php $bimg1 = get_field('home_banner_image_1');
		                if (!empty($bimg1)) {
		                $alt_text = !empty($bimg1['alt']) ? $bimg1['alt'] : $bimg1['title']; ?>
                        <div class="frameImg">
                            <img src="<?php echo esc_url($bimg1['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                        </div>
                    	<?php } ?>
                        <?php $bimg2 = get_field('home_banner_image_2');
		                if (!empty($bimg2)) {
		                $alt_text = !empty($bimg2['alt']) ? $bimg2['alt'] : $bimg2['title']; ?>
                        <div class="frameImg"  data-aos="fade-down">
                            <img src="<?php echo esc_url($bimg2['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                        </div><?php } ?>
                    </div>
                </div>
                <div class="col-md-6" data-aos="fade-right">
                    <div class="innerTxt">
                    	<?php if(get_field('home_banner_heading')){ ?>
                        <h1><?php echo get_field('home_banner_heading'); ?></h1><?php } ?>
                        <?php if(get_field('home_banner_content')){ ?>
                        <p><?php echo get_field('home_banner_content'); ?></p><?php } ?>
                        <?php $homebannerlink = get_field('home_banner_button_link');
                        if ($homebannerlink):
                            $link_url = $homebannerlink['url'];
                            $link_title = $homebannerlink['title'];
                            $link_target = $homebannerlink['target'] ? $homebannerlink['target'] : '_self'; ?>
                        <div class="gp_btn">
                        	<a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn yellowBtn"><?php echo esc_html($link_title); ?></a>
                        </div>
                    	<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="stroke_dots one"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke1.png" alt="stroke-line"></div>
    <div class="stroke_dots two"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke2.png" alt="stroke-line"></div>
    <div class="stroke_dots three"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke3.png" alt="stroke-line"></div>
    <div class="stroke_dots four"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke4.png" alt="stroke-line"></div>
</section>

<section class="hmSec1 defaultPadding">
    <div class="container">
        <div class="row align-items-lg-end mb36">
            <div class="col-lg-8">
            	<?php if(get_field('overview_section_main_heading')){ ?>
                <h2><?php echo get_field('overview_section_main_heading'); ?></h2><?php } ?>
                <?php if(get_field('overview_section_content')){ ?>
                <p><?php echo get_field('overview_section_content'); ?></p><?php } ?>
            </div>
             <?php $viewmore = get_field('overview_section_button_link');
                        if ($viewmore):
                            $link_url = $viewmore['url'];
                            $link_title = $viewmore['title'];
                            $link_target = $viewmore['target'] ? $viewmore['target'] : '_self'; ?>
            <div class="col-lg-4 text-lg-end">
            	<a class="btn" href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?></a>
            </div>
            <?php endif; ?>
        </div>
        <div class="row counter">
            <div class="col-lg-8">
            	<?php $abtimage = get_field('overview_section_image');
			    if (!empty($abtimage)) {
			        $alt_text = !empty($abtimage['alt']) ? $abtimage['alt'] : $abtimage['title']; ?>
                <div class="imgRound">
                    <img src="<?php echo esc_url($abtimage['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
            <?php $counter_list = get_field('counter_list');
            if($counter_list){ ?>
            <div class="col-lg-4 bxAdjust">
            	<?php foreach($counter_list as $index => $counteritem){
            	$delay = ($index === 0) ? '' : 100 * $index; ?>
                <div class="eachCounter" data-aos="moveUpSmooth" <?php if ($delay) : ?> data-aos-delay="<?php echo esc_attr($delay); ?>"<?php endif; ?>>
                    <h3><span data-count="<?php echo $counteritem['counter_number']; ?>" class="count">0</span>+</h3>
                    <p><?php echo $counteritem['counter_text']; ?></p>
                </div>
            	<?php } ?>
            </div>
        	<?php } ?>
        </div>
    </div>
</section>
<?php if( have_rows('service_list') ): ?>
<section class="hmSec2 defaultPadding80">
    <div class="container">
    	<?php if(get_field('service_section_heading')){ ?>
        <h2><?php echo get_field('service_section_heading'); ?></h2>
    	<?php } ?>
        <div class="row">
        	<?php while( have_rows('service_list') ) : the_row();
        	$service_icon = get_sub_field('service_list_icon'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $service_icon ) {
                    $img_url = esc_url( $service_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($service_icon['alt']) ? esc_attr($service_icon['alt']) : esc_attr($service_icon['title']);
                } ?>
            <div class="col-md-4">
                <div class="serItem">
                    <div class="serIcon">
                        <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                    </div>
                    <h4><?php echo get_sub_field('service_list_title'); ?></h4>
                    <ul class="tickCircle">
                    	<?php if( have_rows('service_details') ):
            					while( have_rows('service_details') ) : the_row(); ?>
                        <li><?php echo get_sub_field('service_details_text'); ?></li>
                        <?php endwhile; endif; ?>
                    </ul>
                </div>
            </div>
        <?php endwhile; ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php $value_list = get_field('our_values_list');
            if($value_list){ ?>
<section class="hmSec3 defaultPadding">
    <div class="container">
        <?php if(get_field('our_values_heading')){ ?>
        <h2><?php echo get_field('our_values_heading'); ?></h2>
    	<?php } ?>
        <div class="values_list">
        	<?php foreach($value_list as $valueitem){ ?>
            <div class="eachValue">
                <a href="#?" class="link"></a>
                <div class="left_heading">
                    <span class="numbers"></span>
                    <h4><?php echo $valueitem['our_values_left_text']; ?></h4>
                </div>
                <div class="rigTxt">
                    <p><?php echo $valueitem['our_values_right_text']; ?></p>
                </div>
            </div>
        	<?php } ?>
        </div>
    </div>
</section>
<?php } ?>
<?php $success_list = get_field('client_success_list');
     	if($success_list){ ?>
<section class="hmSec4 defaultPadding80 counter">
    <div class="container">
        <?php if(get_field('client_success_heading')){ ?>
        <h2><?php echo get_field('client_success_heading'); ?></h2>
    	<?php } ?>
        <div class="row">
        	<?php foreach($success_list as $index => $successitem){ 
        		$delay = ($index === 0) ? '' : 400 * $index; ?>
            <div class="col-lg-3 col-md-6"  data-aos="moveUpSmooth" <?php if ($delay) : ?> data-aos-delay="<?php echo esc_attr($delay); ?>"<?php endif; ?>>
                <div class="counter_item">
                    <div class="circleCounter">
                        <h4><span data-count="<?php echo $successitem['client_success_counter_number']; ?>" class="count" data-aos-delay="100">0</span><?php echo $successitem['client_success_number_symbol']; ?></h4>
                    </div>
                    <p><?php echo $successitem['client_success_list_text']; ?></p>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>

<section class="hmSec5 defaultPadding">
    <div class="container">
        <div class="row align-items-lg-center flex-md-row-reverse">
            <div class="col-md-6">
                <?php $cntcimg = get_field('contact_right_side_image');
                        if (!empty($cntcimg)) {
                        $alt_text = !empty($cntcimg['alt']) ? $cntcimg['alt'] : $cntcimg['title']; ?>
                <div class="imgRound">
                    <img src="<?php echo esc_url($cntcimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
            <div class="col-md-6">
                <?php if(get_field('contact_heading')){ ?>
                <h2><?php echo get_field('contact_heading'); ?></h2>
                 <?php } ?>
                <?php echo do_shortcode('[contact-form-7 id="c530843" title="Home Page Form"]'); ?>
            </div>
        </div>
    </div>
</section>

<!-- ! Main end ! -->

<?php get_footer(); ?>