<?php
/**
 * The template for displaying all single posts
 */
get_header(); ?>
<section class="hm_banner innerbanner">
    <?php the_post_thumbnail('full'); ?>
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 m-auto text-center">
                    <h1><?php the_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="blog innerBlog">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-md-7">
                <?php $post_date = get_the_date( 'M j, Y' ); ?>
                <h5><?php echo $post_date; ?></h5>
                <?php the_content(); ?>

                <div class="comment_post">
                    <?php comment_form(); ?>
                    <div class="group_btn_prev_next">
                        <?php
                        // Check for the previous post
                        $previous_post = get_previous_post();
                        $next_post = get_next_post();
                        ?>

                        <a href="<?php echo ($previous_post) ? get_permalink($previous_post) : '#'; ?>" class="btn borderBtn prev <?php echo (!$previous_post) ? 'disabled' : ''; ?>">
                            <span><img src="<?php echo get_template_directory_uri(); ?>/assets/images/blue-arrow.svg" alt="img"></span> Previous
                        </a>

                        <a href="<?php echo ($next_post) ? get_permalink($next_post) : '#'; ?>" class="btn borderBtn next <?php echo (!$next_post) ? 'disabled' : ''; ?>">
                            Next <span><img src="<?php echo get_template_directory_uri(); ?>/assets/images/blue-arrow.svg" alt="img"></span>
                        </a>
                        
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-5">
                <div class="search_info">
                    <form action="<?php echo home_url(); ?>" id="search-form" method="get">
                        <input type="text" name="s" id="s" placeholder="Search" value="" onblur="if(this.value=='')this.value='Search'" onfocus="if(this.value=='type your search')this.value=''" />
                        <input type="submit" value="" />
                    </form>
                </div>
                <div class="subscribe_info">
                    <h3>Subscribe by Email</h3>
                    <?php echo do_shortcode('[contact-form-7 id="92ccffe" title="Blog Subscribe"]'); ?>
                </div>
                <div class="catergories_info">
                    <h3>Categories</h3>
                    <ul>
                        <?php  $categories = get_categories();
                        foreach($categories as $category){
                          echo '<li><a href="' .get_category_link($category->term_id) . '">' . $category->name . '</a></li>';
                        } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer();



