$(document).ready(function () {
  //-------------------------------------------------------
  // 1. StellarNav Menu
  //-------------------------------------------------------
  $(".stellarnav").stellarNav({
    breakpoint: 991,
    position: "right",
  });

  //-------------------------------------------------------
  // 2. FAQ Toggle on Home Page
  //-------------------------------------------------------
  $(".faq_box").each(function () {
    $(this).on("click", ".acc_trigger", function (e) {
      e.preventDefault();

      const $trigger = $(this);
      const $item = $trigger.closest(".faq_item");
      const $container = $item.find(".acc_container");
      const $box = $trigger.closest(".faq_box");

      if ($container.is(":visible")) {
        $container.slideUp(300);
        $trigger.removeClass("active closed");
        $item.removeClass("main_active");
      } else {
        $box.find(".acc_container").slideUp(300);
        $box.find(".acc_trigger").removeClass("active closed");
        $box.find(".faq_item").removeClass("main_active");

        $container.slideDown(300);
        $trigger.addClass("active closed");
        $item.addClass("main_active");
      }
    });
  });

  //-------------------------------------------------------
  // 3. Password Toggle (Eye Icon)
  //-------------------------------------------------------
  // $(".inpt-wrp i").on("click", function () {
  //   const $icon = $(this);
  //   const $input = $icon.siblings("input");
  //   const type = $input.attr("type") === "password" ? "text" : "password";

  //   $input.attr("type", type);
  //   $icon.toggleClass("fa-eye fa-eye-slash");
  // });
});

// ! add Swiper there
document.addEventListener("DOMContentLoaded", function () {
  // ! swiper testimonials
  var swiper = new Swiper(".testimonalSec", {
    slidesPerView: 1,
    spaceBetween: 30,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      768: {
        slidesPerView: 2,
        spaceBetween: 40,
      },
    },
  });

  // ! swiper before and after
  var swiper = new Swiper(".beforeafterSwiper", {
    slidesPerView: 1,
    spaceBetween: 20,
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      767: {
        slidesPerView: 2,
        spaceBetween: 30,
      },
      991: {
        slidesPerView: 3,
        spaceBetween: 30,
      },
    },
  });
});

// ! rating stars with data
document.addEventListener("DOMContentLoaded", function () {
  function renderStars(rating, container) {
    const fullStars = Math.floor(rating);
    const remainder = (rating - fullStars).toFixed(1);
    const partialPercent = Math.round(remainder * 100);
    const partialClass =
      partialPercent > 0
        ? `half_${Math.round(partialPercent / 10) * 10}`
        : null;
    const totalStars = 5;

    container.innerHTML = "";

    for (let i = 0; i < totalStars; i++) {
      const star = document.createElement("span");
      star.classList.add("star");

      if (i < fullStars) {
        star.classList.add("full");
      } else if (i === fullStars && partialClass) {
        star.classList.add("partial", partialClass);
      }

      container.appendChild(star);
    }
  }

  // Apply to multiple containers
  document.querySelectorAll(".star-rating").forEach((el) => {
    const rating = parseFloat(el.dataset.rating);
    renderStars(rating, el);
  });
});

//-------------------------------------------------------
// 6. Counter Animation on Scroll
//-------------------------------------------------------
// let counted = 0;
// $(window).on("scroll", function () {
//   const oTop = $("#counter").offset().top - window.innerHeight;

//   if (counted === 0 && $(window).scrollTop() > oTop) {
//     $(".count").each(function () {
//       const $this = $(this);
//       const countTo = $this.attr("data-count");

//       $({ countNum: $this.text() }).animate(
//         { countNum: countTo },
//         {
//           duration: 2000,
//           easing: "swing",
//           step: function () {
//             $this.text(Math.floor(this.countNum));
//           },
//           complete: function () {
//             $this.text(this.countNum);
//           },
//         }
//       );
//     });
//     counted = 1;
//   }
// });

//-------------------------------------------------------
// 9. splinde slider
//-------------------------------------------------------

// Auto scroll slider
// new Splide("#logo-infinite", {
//   type: "loop",
//   perPage: 5,
//   arrows: false,
//   pagination: false,
//   drag: false,
//   autoWidth: true,
//   gap: "1.25rem",
//   autoScroll: {
//     speed: 2, // smooth speed
//     pauseOnHover: false,
//     pauseOnFocus: false,
//   },
//   extensions: {
//     AutoScroll: window.splide.Extensions.AutoScroll,
//   },
// }).mount(window.splide.Extensions);

// const header = document.querySelector(".header_main");
// let lastScrollY = window.scrollY;

// window.addEventListener("scroll", () => {
//   const currentScrollY = window.scrollY;

//   if (currentScrollY > lastScrollY && currentScrollY > 100) {
//     // Scrolling down and passed 100px
//     header.classList.add("hide");
//     header.classList.add("modify");
//   } else if (currentScrollY < lastScrollY) {
//     // Scrolling up
//     header.classList.remove("hide");
//   }

//   // ✅ When scroll returns to very top (0)
//   if (currentScrollY === 0) {
//     header.classList.remove("modify");
//   }

//   lastScrollY = currentScrollY;
// });

// ! add effect on header
document.addEventListener("DOMContentLoaded", function () {
  const header = document.querySelector(".header_main");
  let lastScrollY = window.scrollY;

  window.addEventListener("scroll", () => {
    const currentScrollY = window.scrollY;

    if (currentScrollY > lastScrollY && currentScrollY > 100) {
      // Scrolling down and passed 100px
      header.classList.add("hide");
      header.classList.add("modify");
    } else if (currentScrollY < lastScrollY) {
      // Scrolling up
      header.classList.remove("hide");

      // 🔹 Remove .openNav only if not near top
      if (currentScrollY > 0) {
        document
          .querySelectorAll(".stellarnav.openNav")
          .forEach((item) => item.classList.remove("openNav"));
      }
    }

    // ✅ When scroll returns to very top (0)
    if (currentScrollY === 0) {
      header.classList.remove("modify");
    }

    lastScrollY = currentScrollY;
  });
});
