<?php /* Template Name: How it works */
get_header();
 ?>

<!-- ! Main ! -->
<section class="innerBanner">
    <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(get_field('how_it_works_content') || get_field('how_it_works_image')){ ?>
<section class="about-us otherPg1 hw_wrk_sec1 sectiondefaultspacing pb-0">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="text">
                    <?php if(get_field('how_it_works_heading')){ ?>
                    <h2 class="otherAdjust"><?php echo get_field('how_it_works_heading'); ?></h2><?php } ?>
                    <?php if(get_field('how_it_works_content')){ ?>
                    <p><?php echo get_field('how_it_works_content'); ?></p><?php } ?>
                    <?php $buttonone = get_field('home_banner_button_1',7);
                        if ($buttonone):
                            $link_url = $buttonone['url'];
                            $link_title = $buttonone['title'];
                            $link_target = $buttonone['target'] ? $buttonone['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                            <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <?php $hwitwrksimg = get_field('how_it_works_image');
                if (!empty($hwitwrksimg)) {
                    $alt_text = !empty($hwitwrksimg['alt']) ? $hwitwrksimg['alt'] : $hwitwrksimg['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($hwitwrksimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php if(get_field('how_works_content') || get_field('how_works_step')){ ?>
<section class="hw_wrk_sec2 sectiondefaultspacing pb-0">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-6">
                <?php if(get_field('how_works_heading')){ ?>
                    <h2 class="otherAdjust"><?php echo get_field('how_works_heading'); ?></h2><?php } ?>
                <?php if(get_field('how_works_content')){ ?>
                    <p><?php echo get_field('how_works_content'); ?></p><?php } ?>
                <div class="btn_adjust">
                    <?php $buttonone = get_field('home_banner_button_1',7);
                        if ($buttonone):
                            $link_url = $buttonone['url'];
                            $link_title = $buttonone['title'];
                            $link_target = $buttonone['target'] ? $buttonone['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                            <?php endif; ?>
                </div>
                <?php $hwworkimg = get_field('how_works_image');
                if (!empty($hwworkimg)) {
                    $alt_text = !empty($hwworkimg['alt']) ? $hwworkimg['alt'] : $hwworkimg['title']; ?>
                <div class="hw_work">
                    <img src="<?php echo esc_url($hwworkimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
            <div class="col-lg-6 col-md-6 ms-auto">
                <ul class="list_counter">
                    <?php $step_count = get_field('how_works_step');
                        if ($step_count) {
                            foreach ($step_count as $step_countitem){ ?>
                    <li>
                        <div class="groupCounter">
                            <div class="counterNumber">
                                <span></span>
                            </div>
                            <h3><?php echo $step_countitem['how_works_step_title']; ?></h3>
                            <p><?php echo $step_countitem['how_works_step_content']; ?></p>
                            <!-- as per client requirement -->
                            <!-- <div class="arrowAbs"><a href="#?" class="arrow_button"><img src="images/arrow_icon_btn.svg" alt=""></a></div> -->
                        </div>
                    </li>
                <?php } } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php $sergetlist = get_field('service_you_get_list',119);
if ($sergetlist) { ?>
<section class="hw_wrk_sec3 sectiondefaultspacing">
    <div class="container">
        <div class="roundBx_hw">
            <?php $whgetimage = get_field('service_you_get_bg_image',119);
            if (!empty($whgetimage)) {
                $alt_text = !empty($whgetimage['alt']) ? $whgetimage['alt'] : $whgetimage['title']; ?>
            <div class="bg_img">
                <img src="<?php echo esc_url($whgetimage['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
            </div><?php } ?>
            <div class="innerTxtHw">
                <?php if(get_field('service_you_get_heading',119)){ ?>
                <h2><?php echo get_field('service_you_get_heading',119); ?></h2><?php } ?>
                <ul class="eachBx">
                    <?php foreach ($sergetlist as $sergetlistitem){ 
                                 // Get the image (assumed to be ACF image field stored as array)
                                $sergeticon = $sergetlistitem['service_you_get_icon']; // assuming 'icon_image' is your image field
                                if (!empty($sergeticon)) {
                                    $alt_text = !empty($sergeticon['alt']) ? $sergeticon['alt'] : $sergeticon['title']; ?>
                    <li>
                        <div class="hwWrk">
                            <div class="wrkIcon">
                                <img src="<?php echo esc_url($sergeticon['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                            </div>
                            <p><?php echo $sergetlistitem['service_you_get_content']; ?></p>
                        </div>
                    </li>
                     <?php } } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                   <?php if(get_field('contact_section_heading',7)){ ?>
                    <h2><?php echo get_field('contact_section_heading',7); ?></h2><?php } ?>
                    <?php if(get_field('contact_section_subheading',7)){ ?>
                    <p><?php echo get_field('contact_section_subheading',7); ?></p><?php } ?>

                    <div class="contacts">
                        <?php $phoneno = get_field('phone_number','option');
                        $tel_number = preg_replace('/\D/', '', $phoneno);
                        if($phoneno){ ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                    <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div>
                        <?php } ?>
                        <?php if(get_field('email','option')) { ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ! Main end ! -->

<?php get_footer(); ?>