<?php /* Template Name: Contact */
get_header();
 ?>

<!-- ! Main ! -->
<section class="innerBanner">
    <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                    <?php if(get_field('contact_page_heading')){ ?>
                    <h2 class="otherAdjust"><?php echo get_field('contact_page_heading'); ?></h2><?php } ?>
                    <?php if(get_field('contact_page_content')){ ?>
                    <p><?php echo get_field('contact_page_content'); ?></p><?php } ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="hw_wrk_sec3 cntSec2 sectiondefaultspacing">
    <div class="container">
        <div class="roundBx_hw">
            <?php $hwbgimg = get_field('contact_last_section_image');
            if (!empty($hwbgimg)) {
                $alt_text = !empty($hwbgimg['alt']) ? $hwbgimg['alt'] : $hwbgimg['title']; ?>
            <div class="bg_img">
                <img src="<?php echo esc_url($hwbgimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
            </div><?php } ?>
            <div class="innerTxtHw">
                <h2>Contact Us</h2>
                <ul class="eachBx twoColummns">
                    <?php $phoneno = get_field('phone_number','option');
                        $tel_number = preg_replace('/\D/', '', $phoneno);
                        if($phoneno){ ?>
                    <li>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="Phone Icon">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                    <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div>
                    </li><?php } ?>
                    <?php if(get_field('email','option')) { ?>
                    <li>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                            </div>
                        </div>
                    </li><?php } ?>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- ! Main end ! -->

<?php get_footer(); ?>