<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<header class="mainhd">
        <div class="container">
            <div class="headerrow">
                <div class="logo">
                    <?php $logoimage = get_field('header_logo','option');
                    if (!empty($logoimage)) {
                        $alt_text = !empty($logoimage['alt']) ? $logoimage['alt'] : $logoimage['title']; ?>
                    <a href="<?php echo get_site_url(); ?>">
                        <img src="<?php echo esc_url($logoimage['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                    </a><?php } ?>
                </div>
                <div class="navigation">
                    <div class="stellarnav">
                        <?php wp_nav_menu( array('menu' => 'Header_Menu', 'container' => '', 'items_wrap' => '<ul class="">%3$s</ul>' )); ?>
                    </div>
                </div>
                <?php $contctbutn = get_field('contact_button','option');
                        if ($contctbutn):
                            $link_url = $contctbutn['url'];
                            $link_title = $contctbutn['title'];
                            $link_target = $contctbutn['target'] ? $contctbutn['target'] : '_self';
                        ?>
                <div class="contact">
                    <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </header>

