<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function moneyfund_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'moneyfund' ) );
    register_nav_menu( 'header', __( 'Header Menu', 'moneyfund' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'moneyfund' ) );
	register_nav_menu( 'privacy', __( 'privacy Menu', 'moneyfund' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'moneyfund_setup' );



function moneyfund_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'moneyfund_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'moneyfund_wp_title', 10, 2 );



function moneyfund_scripts_styles() {
  /*wp_enqueue_style( 'moneyfund-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'moneyfund-style', get_stylesheet_uri(), array(), '2025-05-29' );*/
  wp_enqueue_style( 'moneyfund-style', get_stylesheet_uri(), array(), '2025-05-29' );


	$theme_uri = get_template_directory_uri();

    // Styles
    wp_enqueue_style('bootstrap', $theme_uri . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('owl-carousel', $theme_uri . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('owl-theme', $theme_uri . '/assets/css/owl.theme.default.css');
    wp_enqueue_style('slimnav', $theme_uri . '/assets/css/slimNav_sk78.css');
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css', array(), null);
    wp_enqueue_style('main-style', $theme_uri . '/assets/css/style.css');
    wp_enqueue_style('responsive', $theme_uri . '/assets/css/responsive.css');

    // Scripts
    wp_enqueue_script('jquery'); // WordPress includes jQuery already

    wp_enqueue_script('bootstrap', $theme_uri . '/assets/js/bootstrap.min.js', array('jquery'), null, true);
    wp_enqueue_script('slimnav', $theme_uri . '/assets/js/jquery.slimNav_sk78.min.js', array('jquery'), null, true);
    wp_enqueue_script('owl-carousel', $theme_uri . '/assets/js/owl.carousel.js', array('jquery'), null, true);
    wp_enqueue_script('custom-script', $theme_uri . '/assets/js/script.js', array('jquery'), null, true);
	
}
add_action( 'wp_enqueue_scripts', 'moneyfund_scripts_styles' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');


/*
add_filter('wpcf7_autop_or_not', '__return_false');

add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});*/



//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );



  function enqueue_custom_scripts() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');


//remove <p> contact form
add_filter('wpcf7_autop_or_not', '__return_false');
