$(document).ready(function () {
  //-------------------------------------------------------//
  //! StellarNav Js
  //-------------------------------------------------------//
  if ($(".stellarnav").length) {
    $(".stellarnav").stellarNav({
      breakpoint: 991,
      position: "right",
    });
  }

  $(".left ul li.has-sub").hover(
    function () {
      $(this).children("ul").stop(true, true).slideDown(300);
    },
    function () {
      $(this).children("ul").stop(true, true).slideUp(300);
    }
  );

  //-------------------------------------------------------//
  //! Prod Slider (prodslider)
  //-------------------------------------------------------//
  if ($(".prodslider").length) {
    document.querySelectorAll(".prodslider").forEach(function (el) {
      new Splide(el, {
        type: "loop",
        perPage: 1,
        pagination: true,
        arrows: false,
        autoplay: true,
        interval: 3000, // time between slides (ms)
        pauseOnHover: true,
        rewind: true,
      }).mount();
    });
  }

  //! tabs
  if ($(".tabs").length) {
    $(".tab-links li a").on("click", function (e) {
      e.preventDefault();

      var tabID = $(this).data("tab");

      // remove active class from all
      $(".tab-links li").removeClass("active");
      $(".tab-content .tab").removeClass("active").hide();

      // add active to current li
      $(this).parent("li").addClass("active");

      // show current tab
      $("#" + tabID)
        .fadeIn()
        .addClass("active");
    });

    // trigger first tab on load (if needed)
    $(".tab-links li.active a").trigger("click");
  }

  //! autoscroll slider
  if ($(".autoscroll").length) {
    document.querySelectorAll(".autoscroll").forEach(function (el) {
      new Splide(el, {
        type: "loop",
        drag: "free",
        focus: "center",
        perPage: 5,
        arrows: false,
        pagination: false,
        // Autoscroll options
        autoScroll: {
          speed: 1, // lower = slower; try 0.8–2
          pauseOnHover: true, // pause when hovered
          pauseOnFocus: false, // keep rolling on focus
          rewind: true, // continue seamlessly at edges
        },
      }).mount(window.splide.Extensions); // IMPORTANT for CDN usage
    });
  }

  //! reviewslider
  if ($(".reviewscroll").length) {
    document.querySelectorAll(".reviewscroll").forEach(function (el) {
      new Splide(el, {
        type: "loop",
        drag: "free",
        focus: "center",
        perPage: 4,
        gap: 32,
        arrows: false,
        pagination: false,
        // Autoscroll options
        autoScroll: {
          speed: 1, // lower = slower; try 0.8–2
          pauseOnHover: true, // pause when hovered
          pauseOnFocus: false, // keep rolling on focus
          rewind: true, // continue seamlessly at edges
        },
        breakpoints: {
          991: {
            perPage: 3,
            gap: 16,
            // arrows: false, // show arrows on mobile
            // autoScroll: false, // disable autoscroll on mobile
          },
          767: {
            perPage: 2,
            gap: 16,
            // arrows: false, // show arrows on mobile
            // autoScroll: false, // disable autoscroll on mobile
          },
          480: {
            perPage: 1,
            gap: 12,
            // arrows: false,
            // autoScroll: false,
          },
        },
      }).mount(window.splide.Extensions); // IMPORTANT for CDN usage
    });
  }

  //! sorting box
  if ($(".sorting-bx").length) {
    // Open all initially with flex
    $(".sorting-bx ul").css("display", "flex");

    $(".sorting-bx h5").on("click", function (e) {
      e.preventDefault();

      const $box = $(this).closest(".sorting-bx");
      const $ul = $box.children("ul"); // target only the direct UL

      if ($ul.is(":visible")) {
        // CLOSE — do NOT set display:flex here
        $ul.stop(true, true).slideUp(300);
        $box.removeClass("active");
      } else {
        // OPEN — after slideDown, force flex
        $ul.stop(true, true).slideDown(300, function () {
          $(this).css("display", "flex");
        });
        $box.addClass("active");
      }
    });
  }

  if ($(".recommended-slider").length) {
    document.querySelectorAll(".recommended-slider").forEach(function (el) {
      new Splide(el, {
        // type: "loop",
        perPage: 6, // Show 6 initially
        perMove: 1,
        gap: "16px", // Gap between slides
        arrows: true, // Show arrows
        pagination: false, // Show pagination
        breakpoints: {
          1199: {
            perPage: 6,
            gap: "16px",
          },
          991: {
            perPage: 5,
            gap: "16px",
          },
          767: {
            perPage: 4,
            gap: "10px",
          },
          576: {
            perPage: 3,
            gap: "10px",
          },
          320: {
            perPage: 2,
            gap: "10px",
          },
        },
      }).mount();
    });
  }

  document.querySelectorAll(".custom-select").forEach((select) => {
    const trigger = select.querySelector(".select-trigger");
    const options = select.querySelector(".select-options");

    if (!trigger || !options) return; // skip if markup is incomplete

    trigger.addEventListener("click", () => {
      select.classList.toggle("open");
    });

    options.querySelectorAll(".option").forEach((option) => {
      option.addEventListener("click", () => {
        trigger.textContent = option.textContent;
        select.classList.remove("open");
      });
    });
  });

  window.addEventListener("click", (e) => {
    document.querySelectorAll(".custom-select").forEach((select) => {
      if (!select.contains(e.target)) {
        select.classList.remove("open");
      }
    });
  });

  //-------------------------------------------------------//
  //! Scroll Header Sticky Logic (Mobile)
  //-------------------------------------------------------//
  function checkScroll() {
    if ($(".mainhd").length) {
      if ($(window).width() <= 767) {
        const scrollPoint =
          $(".mainhd").offset().top + $(".mainhd").outerHeight();
        if ($(window).scrollTop() > scrollPoint) {
          $(".mainhd").addClass("fixedClass");
        } else {
          $(".mainhd").removeClass("fixedClass");
        }
      } else {
        $(".mainhd").removeClass("fixedClass");
      }
    }
  }

  checkScroll();
  $(window).on("scroll resize", checkScroll);

  //-------------------------------------------------------//
  //! Repositioning
  //-------------------------------------------------------//
  if (window.innerWidth < 767) {
    const right = document.querySelector(".top-row-inner .hd-right");
    const navigation = document.querySelector(".navigation");

    if (right && navigation) {
      navigation.insertAdjacentElement("afterend", right);
    }
  }
  if (window.innerWidth < 767) {
    $(".openfilter").on("click", function () {
      var sortingOuter = $(".sorting-outer").detach(); // cut it from original place
      $(".appendedcontent").empty().append(sortingOuter); // put it inside modal
    });
  }
  //-------------------------------------------------------//
  //! FAQ Accordion
  //-------------------------------------------------------//
  if ($(".faq_box").length) {
    $(".faq_box").each(function () {
      $(this).on("click", ".acc_trigger", function (e) {
        e.preventDefault();
        var $trigger = $(this);
        var $item = $trigger.closest(".faq_item");
        var $container = $item.find(".acc_container");
        var $faqBox = $trigger.closest(".faq_box");

        if ($container.is(":visible")) {
          $container.slideUp(300);
          $trigger.removeClass("active closed");
          $item.removeClass("main_active");
        } else {
          $faqBox.find(".acc_container").slideUp(300);
          $faqBox.find(".acc_trigger").removeClass("active closed");
          $faqBox.find(".faq_item").removeClass("main_active");

          $container.slideDown(300);
          $trigger.addClass("active closed");
          $item.addClass("main_active");
        }
      });
    });
  }

  //! grid show more and image switcher
  const grid = document.querySelector(".prod-grid");
  const items = grid.querySelectorAll(
    ".prod-main .prodimg-withmore ul.prod-grid li"
  );
  const btn = document.querySelector(".showgrid");
  const mainImg = document.querySelector(".mainprodimg");

  if (grid && items.length && btn) {
    let visibleCount = 4; // show 4 initially
    let expanded = false; // track toggle state

    // Hide items after the first 4
    items.forEach((item, index) => {
      if (index >= visibleCount) {
        item.style.display = "none";
      }
    });

    btn.textContent = "Show More";

    btn.addEventListener("click", function (e) {
      e.preventDefault();

      if (!expanded) {
        // Expand → Show all items
        items.forEach((item) => {
          item.style.display = "block";
        });

        grid.style.maxHeight = "640px"; // adjust based on design
        grid.style.overflowY = "auto";

        btn.textContent = "Hide Items";
        expanded = true;
      } else {
        // Collapse → Show only first 4
        items.forEach((item, index) => {
          item.style.display = index < 4 ? "block" : "none";
        });

        grid.style.maxHeight = "none";
        grid.style.overflowY = "visible";

        btn.textContent = "Show More";
        expanded = false;
      }
    });

    //! ✅ Thumbnail click → Change main image
    items.forEach((item) => {
      const thumb = item.querySelector("img");
      thumb.addEventListener("click", () => {
        mainImg.src = thumb.src;
        mainImg.alt = thumb.alt;

        // Optional: highlight active thumbnail
        items.forEach((li) => li.classList.remove("active"));
        item.classList.add("active");
      });
    });
  }

  //! mobile row and image switcher
  const mobileGrid = document.querySelector(".mobilescroll ul.prod-grid");
  const mobileItems = document.querySelectorAll(
    ".mobilescroll ul.prod-grid li"
  );
  const mainImgMobile = document.querySelector(".mainprodimg");

  if (mobileGrid && mobileItems.length && mainImgMobile) {
    // ✅ Create "View All" button dynamically
    const viewAllBtn = document.createElement("li");
    viewAllBtn.classList.add("view-all");
    viewAllBtn.innerHTML = `<span>View All</span>`;
    mobileGrid.appendChild(viewAllBtn);

    // ✅ Initially show only first 4 thumbnails + View All btn
    mobileItems.forEach((item, index) => {
      if (index >= 3) {
        item.style.display = "none";
      }
    });

    // ✅ Thumbnail click → change main image
    mobileItems.forEach((item) => {
      const img = item.querySelector("img");
      if (img) {
        img.addEventListener("click", () => {
          mainImgMobile.src = img.src;
          mainImgMobile.alt = img.alt;

          // Highlight active
          mobileItems.forEach((li) => li.classList.remove("active"));
          item.classList.add("active");
        });
      }
    });

    // ✅ View All click → show all items and allow scroll
    viewAllBtn.addEventListener("click", (e) => {
      e.preventDefault();
      mobileItems.forEach((item) => {
        item.style.display = "block";
      });
      viewAllBtn.style.display = "none"; // hide "View All" once expanded
      mobileGrid.classList.add("active");
      // Force scroll into view
      // ✅ Smoothly scroll the thumbnail row to the end
      mobileGrid.parentElement.scrollTo({
        left: mobileGrid.scrollWidth,
        behavior: "smooth",
      });
    });
  }

  //! Tab switcher
  const tabs = document.querySelectorAll(".tabsec-prod > ul > li");
  const contents = document.querySelectorAll(".tabcontent-prod");

  if (!tabs.length || !contents.length) return;

  // ✅ Attach checkbox handler (so parent li toggles .active)
  document
    .querySelectorAll(".selecter-prod input[type='checkbox']")
    .forEach((cb) => {
      cb.addEventListener("change", function () {
        const li = this.closest("li");
        if (li) {
          li.classList.toggle("active", this.checked);
        }
      });
    });

  // ✅ Refresh li.active for checked inputs
  function refreshActiveStates(container) {
    container.querySelectorAll("input[type='checkbox']").forEach((cb) => {
      const li = cb.closest("li");
      if (li) {
        li.classList.toggle("active", cb.checked);
      }
    });
  }

  // ✅ Tab switching
  tabs.forEach((tab, index) => {
    tab.addEventListener("click", function () {
      // Remove active from all tabs
      tabs.forEach((t) => t.classList.remove("active"));
      this.classList.add("active");

      // Show only the related content
      contents.forEach((c, i) => {
        if (i === index) {
          c.style.display = "block";
          refreshActiveStates(c); // re-apply li.active if checkboxes checked
        } else {
          c.style.display = "none";
        }
      });
    });
  });

  // ✅ Init first tab as active
  tabs[0].classList.add("active");
  contents.forEach((c, i) => {
    c.style.display = i === 0 ? "block" : "none";
    if (i === 0) refreshActiveStates(c);
  });

  //! check checkboxes to add active class
  document.querySelectorAll(".select-inner").forEach((selectInner) => {
    const checkboxes = selectInner.querySelectorAll("input[type='checkbox']");

    checkboxes.forEach((checkbox) => {
      checkbox.addEventListener("change", function () {
        if (this.checked) {
          this.parentElement.classList.add("active");
        } else {
          this.parentElement.classList.remove("active");
        }
      });

      // On page load, sync checked state
      if (checkbox.checked) {
        checkbox.parentElement.classList.add("active");
      }
    });
  });

  //! Bundle tab
  const bundleTabs = document.querySelectorAll(".bundles-nav ul li");
  const bundleContents = document.querySelectorAll(".bundle-content");

  bundleTabs.forEach((tab, index) => {
    tab.addEventListener("click", () => {
      // remove active class from all tabs
      bundleTabs.forEach((t) => t.classList.remove("active"));
      // add active to clicked tab
      tab.classList.add("active");

      // hide all contents
      bundleContents.forEach((c) => c.classList.remove("active"));
      // show content matching index
      bundleContents[index].classList.add("active");
    });
  });

  //! Bundle item toggle
  document.querySelectorAll(".bundle-content").forEach((content) => {
    const items = content.querySelectorAll("li");

    items.forEach((item) => {
      item.addEventListener("click", () => {
        // toggle active on clicked li
        item.classList.toggle("active");
      });
    });
  });

  //! quaNtity
  const quantityControl = document.querySelector(".quantity-control");
  const minusBtn = quantityControl.querySelector(".minus");
  const plusBtn = quantityControl.querySelector(".plus");
  const numberEl = quantityControl.querySelector(".number");

  let count = 1; // initial value
  const min = 1; // minimum allowed
  const max = 10; // maximum allowed (optional)

  function updateDisplay() {
    numberEl.textContent = count;
    minusBtn.disabled = count <= min;
    plusBtn.disabled = count >= max;
  }

  minusBtn.addEventListener("click", () => {
    if (count > min) {
      count--;
      updateDisplay();
    }
  });

  plusBtn.addEventListener("click", () => {
    if (count < max) {
      count++;
      updateDisplay();
    }
  });

  updateDisplay(); // init

  //! description tab
  const tabButtons = document.querySelectorAll(".desc-tab ul li");
  const tabContents = document.querySelectorAll(".desc-tabcontent");

  // run only if tabs and contents exist
  if (tabButtons.length > 0 && tabContents.length > 0) {
    tabButtons.forEach((tab, index) => {
      tab.addEventListener("click", () => {
        // remove active from all tabs
        tabButtons.forEach((t) => t.classList.remove("active"));
        // add active to clicked tab
        tab.classList.add("active");

        // hide all contents
        tabContents.forEach((c) => c.classList.remove("active"));
        // show content that matches tab index (with safety check)
        if (tabContents[index]) {
          tabContents[index].classList.add("active");
        }
      });
    });
  }
});

//-------------------------------------------------------//
//! Match Height for Headings
//-------------------------------------------------------//
$(function () {
  if (
    $.fn.matchHeight &&
    $(".prod-main .tabsec-prod .tabcontent-prod-outer .tabcontent-prod ul li")
      .length
  ) {
    $(
      ".prod-main .tabsec-prod .tabcontent-prod-outer .tabcontent-prod ul li"
    ).matchHeight();
  }
});
